/******************************************************************************
*
* Freescale(TM) and the Freescale logo are trademarks of Freescale Semiconductor, Inc.
* All other product or service names are the property of their respective owners.
* (C) Freescale Semiconductor, Inc. 2007
*
* THIS SOURCE CODE IS CONFIDENTIAL AND PROPRIETARY AND MAY NOT
* BE USED OR DISTRIBUTED WITHOUT THE WRITTEN PERMISSION OF
* Freescale Semiconductor, Inc.
*
* Filename:     $Source: /u/OSEK/src/axe/inc/axeapi.h,v $
* Author:       $Author: b09107 $
* Revision:     $Revision: 1.13 $
*
* Functions:
*
* History:      Use the CVS command rlog to display revision history
*
* Description:  AXE Scheduler PUBLIC API
*
* Notes:  For detailes see: "Draft AXE Scheduler API Version 1.0.2"       
*
******************************************************************************/

#ifndef AXE_API_H
#define AXE_API_H

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

#include "axetypes.h"
 
/*
 * Task management API
 */
StatusType ActivateTask ( TaskType TaskID );
StatusType TerminateTask ( void );
void Yield ( void );

/*
 * Interrupt management API
 */
void SuspendAllInterrupts ( void );
void ResumeAllInterrupts ( void );

/*
 * Memory management API
 */
MemRefType AllocMem ( SizeType Size, SegmentType Segment );
StatusType FreeMem ( MemRefType MemoryRef );

/*
 * Semaphore API
 */
StatusType GetSem ( SemType SemID );
StatusType ReleaseSem ( SemType SemID );
StatusType GetSemStatus ( SemType SemID );

/* 
 * Messages API 
 */
StatusType InitMessage ( void );
StatusType SendMessageToTask ( TaskType TaskID, MsgRefType MsgRef );
StatusType SendMessageToHost ( TaskType TaskID, MsgRefType MsgRef );
StatusType ReceiveMessage ( MsgRefType* MsgRef );
StatusType MessageIsProcessed ( MsgRefType MsgRef );
StatusType GetMessageStatus ( TaskType TaskID, QueueStatusRefType QueueStatusRef );

/*
 * Debug API
 */
StatusType CPrint ( const char *OutputStringRef );
StatusType CScan ( char *InputStringRef, SizeType BufSize );


#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif  /* AXE_API_H */
